/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.starjavapos.Star;

import com.starmicronics.stario.StarIOPort;
import com.starmicronics.stario.StarIOPortException;
import com.starmicronics.stario.StarPrinterStatus;
import com.starmicronics.utility.OutputDataSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.CashDrawerService113;
import jpos.services.EventCallbacks;

public class CashDrawerStarService
implements CashDrawerService113,
ActionListener {
    private boolean m_deviceEnabled;
    private int[] m_serviceState = new int[]{1};
    private int[] m_powerNotifyEnabled = new int[]{0};
    private int[] m_powerState = new int[]{2000};
    private int m_errorLevel;
    private int m_errorStation;
    private String m_errorString;
    private String m_checkHealthText = "";
    private static StarIOPort m_port;
    private String m_portName;
    private String m_portSettings;
    private int m_ioTimeoutMillis = 5000;
    private int m_ioProgressTimeout = 10000;
    private EventCallbacks m_eventCallbacks;
    private Object m_eventLock = new Object();
    private Vector m_eventQueue = new Vector();
    private boolean m_freezeEvents;
    private boolean m_eventThreadLife = true;
    private Thread m_eventThread;
    private Object m_statusLock = new Object();
    private boolean m_statusThreadLife = true;
    private Thread m_statusThread;
    private StarPrinterStatus[] m_cachedStatus = new StarPrinterStatus[]{new StarPrinterStatus()};
    private boolean m_controlPrimaryDrawer = true;
    private long m_firePulseWidth = 200L;
    private long m_sleepPulseWidth = 200L;
    private boolean m_capStatus = false;
    private boolean m_signalLevelHighWhenDrawerOpen = true;
    private boolean[] m_claimLock;
    JButton button;
    JTextField textField;

    public CashDrawerStarService(JposEntry jposEntry, boolean[] blArray) throws JposException {
        if (!jposEntry.hasPropertyWithName("portName") || jposEntry.getPropertyType("portName") != String.class) {
            throw new JposException(104, "A required configuration property (\"portName\" of type String) is missing.");
        }
        this.m_portName = (String)jposEntry.getPropertyValue("portName");
        if (!jposEntry.hasPropertyWithName("portSettings") || jposEntry.getPropertyType("portSettings") != String.class) {
            throw new JposException(104, "A required configuration property (\"portSettings\" of type String) is missing.");
        }
        this.m_portSettings = (String)jposEntry.getPropertyValue("portSettings");
        if (jposEntry.hasPropertyWithName("ioTimeoutMillis") && jposEntry.getPropertyType("ioTimeoutMillis") == Integer.class) {
            this.m_ioTimeoutMillis = (Integer)jposEntry.getPropertyValue("ioTimeoutMillis");
        }
        if (jposEntry.hasPropertyWithName("ioProgressTimeout") && jposEntry.getPropertyType("ioProgressTimeout") == Integer.class) {
            this.m_ioProgressTimeout = (Integer)jposEntry.getPropertyValue("ioProgressTimeout");
        }
        if (jposEntry.hasPropertyWithName("controlPrimaryDrawer") && jposEntry.getPropertyType("controlPrimaryDrawer") == Boolean.class) {
            this.m_controlPrimaryDrawer = (Boolean)jposEntry.getPropertyValue("controlPrimaryDrawer");
        }
        if (jposEntry.hasPropertyWithName("firePulseWidth") && jposEntry.getPropertyType("firePulseWidth") == Long.class) {
            this.m_firePulseWidth = (Long)jposEntry.getPropertyValue("firePulseWidth");
        }
        if (jposEntry.hasPropertyWithName("sleepPulseWidth") && jposEntry.getPropertyType("sleepPulseWidth") == Long.class) {
            this.m_sleepPulseWidth = (Long)jposEntry.getPropertyValue("sleepPulseWidth");
        }
        if (jposEntry.hasPropertyWithName("capStatus") && jposEntry.getPropertyType("capStatus") == Boolean.class) {
            this.m_capStatus = (Boolean)jposEntry.getPropertyValue("capStatus");
        }
        if (jposEntry.hasPropertyWithName("signalLevelHighWhenDrawerOpen") && jposEntry.getPropertyType("signalLevelHighWhenDrawerOpen") == Boolean.class) {
            this.m_signalLevelHighWhenDrawerOpen = (Boolean)jposEntry.getPropertyValue("signalLevelHighWhenDrawerOpen");
        }
        this.m_claimLock = blArray;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void deleteInstance() throws JposException {
        try {
            this.close();
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    public String getCheckHealthText() throws JposException {
        return this.m_checkHealthText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getClaimed() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_claimLock[0];
        }
    }

    public boolean getDeviceEnabled() throws JposException {
        return this.m_deviceEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceEnabled(boolean bl) throws JposException {
        if (bl == this.m_deviceEnabled) {
            return;
        }
        if (bl) {
            try {
                m_port = StarIOPort.getPort((String)this.m_portName, (String)this.m_portSettings, (int)this.m_ioTimeoutMillis);
                this.m_cachedStatus[0] = m_port.retreiveStatus();
            }
            catch (StarIOPortException starIOPortException) {
                throw new JposException(107, "The device communications channel could not be opened, chech the device and retry.");
            }
            if (null != this.m_eventThread) {
                return;
            }
            this.m_eventThreadLife = true;
            this.m_eventThread = new Thread(new EventServer());
            this.m_eventThread.start();
            if (null != this.m_statusThread) {
                return;
            }
            this.m_statusThreadLife = true;
            this.m_statusThread = new Thread(new StatusServer());
            this.m_statusThread.start();
            this.m_deviceEnabled = true;
        } else {
            Object object = this.m_statusLock;
            synchronized (object) {
                this.m_statusThreadLife = false;
                this.m_statusLock.notifyAll();
            }
            try {
                this.m_statusThread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.m_statusThread = null;
            }
            object = this.m_eventLock;
            synchronized (object) {
                this.m_eventThreadLife = false;
                this.m_eventLock.notifyAll();
            }
            try {
                this.m_eventThread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.m_eventThread = null;
            }
            StarIOPort.releasePort((StarIOPort)m_port);
            m_port = null;
            this.m_deviceEnabled = false;
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        return "Star Micronics JavaPOS CashDrawer Service Driver";
    }

    public int getDeviceServiceVersion() throws JposException {
        return 1013004;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFreezeEvents() throws JposException {
        Object object = this.m_eventLock;
        synchronized (object) {
            return this.m_freezeEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreezeEvents(boolean bl) throws JposException {
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_freezeEvents = bl;
            this.m_eventLock.notifyAll();
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        return "Printer controlled cash drawer";
    }

    public String getPhysicalDeviceName() throws JposException {
        return "Star Micronics Cash Drawer Controller";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() throws JposException {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_serviceState[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void claim(int n) throws JposException {
        if (-1 > n) {
            throw new JposException(106, "The claim operation was aborted because an invalid timeout parameter was specified.");
        }
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            while (this.m_claimLock[0] && 0 < n) {
                try {
                    long l = System.currentTimeMillis();
                    this.m_claimLock.wait(n);
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 > (long)n) {
                        n = 0;
                        continue;
                    }
                    n = (int)((long)n - l2);
                }
                catch (InterruptedException interruptedException) {
                    throw new JposException(106, "The claim operation was aborted because of thread interruption.");
                }
            }
            if (!this.m_claimLock[0]) {
                this.m_claimLock[0] = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            throw new JposException(112, "The claim operation timed out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JposException {
        if (2 != this.getState()) {
            throw new JposException(113, "This request is illegal because the service is busy processing asynchronous output.");
        }
        try {
            this.setDeviceEnabled(false);
        }
        catch (JposException jposException) {
            // empty catch block
        }
        try {
            this.release();
        }
        catch (JposException jposException) {
            // empty catch block
        }
        if (null != m_port) {
            StarIOPort.releasePort((StarIOPort)m_port);
            m_port = null;
        }
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            this.m_serviceState[0] = 1;
            // ** MonitorExit[var1_3] (shouldn't be in output)
            return;
        }
    }

    public void checkHealth(int n) throws JposException {
        this.verifyEnabledState();
        if (2 == n) {
            try {
                this.openDrawer();
                this.m_checkHealthText = "The execution of checkHealth succeeded.";
            }
            catch (JposException jposException) {
                this.m_checkHealthText = jposException.getMessage();
                throw jposException;
            }
        }
        if (3 == n) {
            JFrame jFrame = new JFrame("JavaPOS POSPrinter");
            jFrame.setState(1);
            jFrame.setExtendedState(1);
            jFrame.setBounds(0, 0, 0, 0);
            jFrame.setResizable(false);
            jFrame.setUndecorated(true);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JDialog jDialog = new JDialog(jFrame, "JavaPOS CashDrawer", true);
            jDialog.setSize(350, 110);
            jDialog.setResizable(false);
            Rectangle rectangle = jDialog.getGraphicsConfiguration().getBounds();
            jDialog.setLocation(rectangle.x + rectangle.width / 2 - jDialog.getSize().width / 2, rectangle.y + rectangle.height / 2 - jDialog.getSize().height / 2);
            Container container = jDialog.getContentPane();
            JPanel jPanel = new JPanel();
            this.button = new JButton("CheckHealth");
            this.button.setPreferredSize(new Dimension(323, 28));
            this.button.addActionListener(this);
            jPanel.add(this.button);
            jDialog.getRootPane().setDefaultButton(this.button);
            container.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            this.textField = new JTextField("");
            this.textField.setPreferredSize(new Dimension(323, 26));
            this.textField.setEditable(false);
            jPanel2.add(this.textField);
            container.add((Component)jPanel2, "Last");
            jDialog.setDefaultCloseOperation(2);
            jFrame.setDefaultCloseOperation(2);
            jFrame.pack();
            jFrame.setVisible(false);
            jDialog.setVisible(true);
            jDialog.hide();
            jFrame.dispose();
        } else {
            throw new JposException(106, "This request failed because the specified checkHealth level is unsupported.");
        }
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        throw new JposException(106, "This request failed because the specified command parameter is unsupported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(String string, EventCallbacks eventCallbacks) throws JposException {
        this.m_eventCallbacks = eventCallbacks;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            this.m_serviceState[0] = 2;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            if (!this.m_claimLock[0]) {
                throw new JposException(106, "This request is illegal because the service is not already claimed.");
            }
            this.setDeviceEnabled(false);
            this.m_claimLock[0] = false;
            this.m_claimLock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean getCapStatus() throws JposException {
        return this.m_capStatus;
    }

    public int getCapPowerReporting() throws JposException {
        return 2;
    }

    public boolean getCapStatusMultiDrawerDetect() throws JposException {
        return false;
    }

    public boolean getCapStatisticsReporting() throws JposException {
        return false;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        return false;
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        return false;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDrawerOpened() throws JposException {
        this.verifyEnabledState();
        if (!this.m_capStatus) {
            return false;
        }
        StarPrinterStatus[] starPrinterStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            if (this.m_signalLevelHighWhenDrawerOpen) {
                if (this.m_cachedStatus[0].compulsionSwitch) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            if (!this.m_cachedStatus[0].compulsionSwitch) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerNotify() throws JposException {
        int[] nArray = this.m_powerNotifyEnabled;
        synchronized (this.m_powerNotifyEnabled) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_powerNotifyEnabled[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerNotify(int n) throws JposException {
        if (this.m_deviceEnabled) {
            throw new JposException(106, "This request is illegal because the deviceEnabled is true.");
        }
        if (0 != n && 1 != n) {
            throw new JposException(106, "This request is illegal because the powerNotify parameter is unsupported.");
        }
        int[] nArray = this.m_powerNotifyEnabled;
        synchronized (this.m_powerNotifyEnabled) {
            this.m_powerNotifyEnabled[0] = n;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerState() throws JposException {
        int[] nArray = this.m_powerState;
        synchronized (this.m_powerState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_powerState[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPowerState(int n) {
        int[] nArray = this.m_powerState;
        synchronized (this.m_powerState) {
            this.m_powerState[0] = n;
            this.m_powerState.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDrawer() throws JposException {
        this.verifyEnabledState();
        StarIOPort starIOPort = m_port;
        synchronized (starIOPort) {
            this.updateStatus();
            if (2003 == this.getPowerState()) {
                throw new JposException(108, "This print operation failed because the device is offline.");
            }
            if (2002 == this.getPowerState()) {
                throw new JposException(107, "This print operation failed because the device is off.");
            }
            byte[] byArray = null;
            byArray = true == this.m_controlPrimaryDrawer ? new byte[]{27, 7, (byte)(this.m_firePulseWidth / 10L), (byte)(this.m_sleepPulseWidth / 10L), 7, 27, 66, 27, 31, 112, 3, 0, 0} : new byte[]{26, 27, 66, 27, 31, 112, 3, 0, 0};
            OutputDataSet outputDataSet = new OutputDataSet();
            outputDataSet.addOutputData(byArray);
            try {
                for (int i = 0; i < outputDataSet.getSize(); ++i) {
                    int n;
                    int n2;
                    byte[] byArray2 = outputDataSet.getOutputData(i);
                    long l = System.currentTimeMillis();
                    for (n = 0; System.currentTimeMillis() - l < (long)this.m_ioProgressTimeout && n < byArray2.length; n += n2) {
                        n2 = m_port.writePort(byArray2, n, byArray2.length - n);
                        if (n2 == 0) continue;
                        l = System.currentTimeMillis();
                    }
                    if (n >= byArray2.length) continue;
                    this.updateStatus();
                    throw new JposException(112);
                }
            }
            catch (StarIOPortException starIOPortException) {
                this.updateStatus();
                throw new JposException(112);
            }
        }
        if (!this.m_capStatus) {
            return;
        }
        long l = System.currentTimeMillis();
        do {
            long l2 = System.currentTimeMillis();
            this.updateStatus();
            if (this.getDrawerOpened()) break;
            if (0L >= (l2 = 100L + l2 - System.currentTimeMillis())) continue;
            try {
                Thread.sleep(l2);
            }
            catch (Exception exception) {
                throw new JposException(111);
            }
        } while (System.currentTimeMillis() - l < (long)this.m_ioProgressTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDrawerClose(int n, int n2, int n3, int n4) throws JposException {
        this.verifyEnabledState();
        if (!this.m_capStatus) {
            return;
        }
        StarPrinterStatus[] starPrinterStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            if (this.m_signalLevelHighWhenDrawerOpen) {
                while (this.m_cachedStatus[0].compulsionSwitch) {
                    try {
                        this.m_cachedStatus.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new JposException(106, "This request failed because this thread was interrupted.");
                    }
                    if (2002 != this.getPowerState() && 2003 != this.getPowerState()) continue;
                    throw new JposException(108, "This request failed because because the device is offline.");
                }
            } else {
                while (!this.m_cachedStatus[0].compulsionSwitch) {
                    try {
                        this.m_cachedStatus.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new JposException(106, "This request failed because this thread was interrupted.");
                    }
                    if (2002 != this.getPowerState() && 2003 != this.getPowerState()) continue;
                    throw new JposException(108, "This request failed because because the device is offline.");
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void resetStatistics(String string) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void updateStatistics(String string) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void updateFirmware(String string) throws JposException {
        this.verifyClaimedState();
        this.verifyEnabledState();
        throw new JposException(106, "This request failed because this function is not supported.");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.button)) {
            try {
                this.verifyEnabledState();
                this.openDrawer();
                this.m_checkHealthText = "The execution of checkHealth succeeded.";
            }
            catch (JposException jposException) {
                this.m_checkHealthText = jposException.getMessage();
                switch (jposException.getErrorCode()) {
                    case 0: {
                        this.textField.setText("JPOS_SUCCESS");
                        break;
                    }
                    case 101: {
                        this.textField.setText("JPOS_E_CLOSED");
                        break;
                    }
                    case 102: {
                        this.textField.setText("JPOS_E_CLAIMED");
                        break;
                    }
                    case 103: {
                        this.textField.setText("JPOS_E_NOTCLAIMED");
                        break;
                    }
                    case 104: {
                        this.textField.setText("JPOS_E_NOSERVICE");
                        break;
                    }
                    case 105: {
                        this.textField.setText("JPOS_E_DISABLED");
                        break;
                    }
                    case 106: {
                        this.textField.setText("JPOS_E_ILLEGAL");
                        break;
                    }
                    case 107: {
                        this.textField.setText("JPOS_E_NOHARDWARE");
                        break;
                    }
                    case 108: {
                        this.textField.setText("JPOS_E_OFFLINE");
                        break;
                    }
                    case 109: {
                        this.textField.setText("JPOS_E_NOEXIST");
                        break;
                    }
                    case 110: {
                        this.textField.setText("JPOS_E_EXISTS");
                        break;
                    }
                    case 111: {
                        this.textField.setText("JPOS_E_FAILURE");
                        break;
                    }
                    case 112: {
                        this.textField.setText("JPOS_E_TIMEOUT");
                        break;
                    }
                    case 113: {
                        this.textField.setText("JPOS_E_BUSY");
                        break;
                    }
                    default: {
                        this.textField.setText("ResultCode Error !?");
                    }
                }
                return;
            }
            this.textField.setText("JPOS_SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(JposEvent jposEvent) {
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_eventQueue.add(jposEvent);
            this.m_eventLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() throws JposException {
        StarIOPort starIOPort = m_port;
        synchronized (starIOPort) {
            StarPrinterStatus starPrinterStatus;
            try {
                starPrinterStatus = m_port.retreiveStatus();
            }
            catch (StarIOPortException starIOPortException) {
                if (1 == this.getPowerNotify() && 2002 != this.getPowerState()) {
                    this.setPowerState(2002);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2002));
                }
                throw new JposException(107, "This print operation failed because device communication failed.");
            }
            if (1 == this.getPowerNotify()) {
                if (starPrinterStatus.offline) {
                    if (2003 != this.getPowerState()) {
                        this.setPowerState(2003);
                        this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                    }
                } else if (2002 == this.getPowerState()) {
                    this.setPowerState(2003);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                }
            }
            try {
                if (1 == this.getPowerNotify()) {
                    if (starPrinterStatus.offline) {
                        if (2003 != this.getPowerState()) {
                            this.setPowerState(2003);
                            this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                        }
                    } else if (2001 != this.getPowerState()) {
                        this.setPowerState(2001);
                        this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                    }
                }
                StarPrinterStatus[] starPrinterStatusArray = this.m_cachedStatus;
                synchronized (this.m_cachedStatus) {
                    StarPrinterStatus starPrinterStatus2 = this.m_cachedStatus[0];
                    this.m_cachedStatus[0] = starPrinterStatus;
                    this.m_cachedStatus.notifyAll();
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    if (this.getCapStatus()) {
                        if (this.m_signalLevelHighWhenDrawerOpen) {
                            if (starPrinterStatus.compulsionSwitch) {
                                if (!starPrinterStatus2.compulsionSwitch) {
                                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 1));
                                }
                            } else if (starPrinterStatus2.compulsionSwitch) {
                                this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 0));
                            }
                        } else if (!starPrinterStatus.compulsionSwitch) {
                            if (starPrinterStatus2.compulsionSwitch) {
                                this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 1));
                            }
                        } else if (!starPrinterStatus2.compulsionSwitch) {
                            this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 0));
                        }
                    }
                    Object var7_7 = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (1 == this.getPowerNotify() && !starPrinterStatus.offline && 2001 != this.getPowerState()) {
                    this.setPowerState(2001);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                }
                throw throwable;
            }
            {
                if (1 == this.getPowerNotify() && !starPrinterStatus.offline && 2001 != this.getPowerState()) {
                    this.setPowerState(2001);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyClaimedState() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            if (!this.m_claimLock[0]) {
                throw new JposException(103, "The service is not claimed.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void verifyEnabledState() throws JposException {
        if (!this.m_deviceEnabled) {
            throw new JposException(105, "The service is not enabled.");
        }
    }

    private class StatusServer
    implements Runnable {
        private StatusServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = CashDrawerStarService.this.m_statusLock;
                synchronized (object) {
                    if (!CashDrawerStarService.this.m_statusThreadLife) {
                        break;
                    }
                }
                try {
                    CashDrawerStarService.this.updateStatus();
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                object = CashDrawerStarService.this.m_statusLock;
                synchronized (object) {
                    try {
                        CashDrawerStarService.this.m_statusLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class EventServer
    implements Runnable {
        private EventServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                JposEvent jposEvent = null;
                Object object = CashDrawerStarService.this.m_eventLock;
                synchronized (object) {
                    while ((CashDrawerStarService.this.m_freezeEvents || CashDrawerStarService.this.m_eventQueue.isEmpty()) && CashDrawerStarService.this.m_eventThreadLife) {
                        try {
                            CashDrawerStarService.this.m_eventLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    if (!CashDrawerStarService.this.m_eventThreadLife) {
                        return;
                    }
                    jposEvent = (JposEvent)CashDrawerStarService.this.m_eventQueue.remove(0);
                }
                if (jposEvent instanceof StatusUpdateEvent) {
                    CashDrawerStarService.this.m_eventCallbacks.fireStatusUpdateEvent((StatusUpdateEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof OutputCompleteEvent) {
                    CashDrawerStarService.this.m_eventCallbacks.fireOutputCompleteEvent((OutputCompleteEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof DataEvent) {
                    CashDrawerStarService.this.m_eventCallbacks.fireDataEvent((DataEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof ErrorEvent) {
                    CashDrawerStarService.this.m_eventCallbacks.fireErrorEvent((ErrorEvent)jposEvent);
                    continue;
                }
                if (!(jposEvent instanceof DirectIOEvent)) continue;
                CashDrawerStarService.this.m_eventCallbacks.fireDirectIOEvent((DirectIOEvent)jposEvent);
            }
        }
    }
}

